@extends('layouts.master_panel')

@section('title') Fournitures de l'année @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

<link rel="stylesheet" href="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.css" />


@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" },
      "order": [[ 0, "desc" ]]
    });
  });
  </script>


<script src="{{url('/')}}/assets/vendor/datepicker/moment.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/datepicker.js"></script>

<script src="{{url('/')}}/assets/vendor/datepicker/fr.js"></script>

<script type="text/javascript">
    $(function () {
        $('#datetimepickerdate').datetimepicker({
          format: 'DD/MM/YYYY',
          locale: 'fr'
      });
    });

</script>



<script type="text/javascript">
$(document).ready(function () { 

  $('.donebox').change(function() {

      var id = this.id;
      var idSplit = id.split("-");

      if(this.checked) {
        $('#is_absent'+idSplit[1]).val('1');
      } else {
        $('#is_absent'+idSplit[1]).val('0'); 
      } 
  
  });


});
</script>


@stop


@section('content')


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Fournitures de l'année </h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item active" aria-current="page">Fournitures de l'année  </li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">

<div class="col-md-12">
@if(Session::has('error'))

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('error') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

@endif

@if(Session::has('success'))
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('success') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif
</div>
<div class="clearfix"></div>



<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">

@if(auth()->user()->is_admin == 1)
    <h5 class="card-header">
      <a href="#" class="btn btn-primary mb-1" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-plus"></i> Ajouter </a>

      <a href="#" class="btn btn-primary mb-1 ml-2" data-toggle="modal" data-target="#exampleModal2"><i class="fa fa-print"></i> Fournitures </a>
    </h5>
@endif

@if(auth()->user()->is_teacher == 1)
    <h5 class="card-header">
      <a href="#" class="btn btn-primary mb-1" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-plus"></i> Ajouter </a>
    </h5>
@endif

  <div class="card-body">

@if(auth()->user()->is_admin == 1)

<!-- Modal -->
<div class="modal fade" id="exampleModal2" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel2" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel2">Fournitures</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="GET" target="_black" action="{{ URL::route('print_fournitures_annee') }}">

<div class="form-row">

  <div class="col-md-12 mb-3">
      <label>Classes:</label>
      <select name="class_id[]" class="selectpicker" data-width="100%" required="required" multiple="multiple" title="Choisir">  

        <option value="0">Tout sélectionner</option> 
        @foreach($classes as $classe)
          <option value="{{ $classe->id }}">{{ $classe->name }}</option>
        @endforeach
      </select>
  </div>


  <div class="col-md-12 mb-3">
    <label>Remarque:</label>
    <textarea name="remarque" class="form-control" rows="4"></textarea>
  </div>

 
</div>

<div class="form-row mt-1">
<div class="col-md-12">
    <button class="btn btn-success btn-block" type="submit">Fournitures</button>
</div>
</div>

</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->

@endif







<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel">Ajouter</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

@if(auth()->user()->is_admin == 1)
<form method="POST" action="{{ URL::route('admin_store_fournitures') }}" >
@endif

@if(auth()->user()->is_teacher == 1)
<form method="POST" action="{{ URL::route('fournitures_annee_store') }}" >
@endif

{{ csrf_field() }}

<div class="form-row">

  <div class="col-md-12 mb-3">
      <label>Matières / Classes</label>
      <select name="subject_id" class="selectpicker" data-width="100%" required="required">   
      <option value="">Choisir</option>
        @foreach($subjects as $subject)

        <?php $getclass = \App\Classes::find($subject->class_id); ?>

          <option value="{{ $subject->id }}">{{ $subject->name }} ({{ $getclass->name }})</option>
        @endforeach
      </select>
  </div>


  <div class="col-md-12 mb-3">
    <label>Fournitures:</label>
    <textarea name="details" class="form-control" rows="8"></textarea>
  </div>


 
</div>

<div class="form-row mt-1">
<div class="col-md-12">
    <button class="btn btn-success btn-block" type="submit">Ajouter</button>
</div>
</div>

</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->





<div class="clearfix"></div>



      <div class="table-responsive">
          <table id="example" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th style="display: none;"></th>
              <th>Classe</th>
              <th>Matière</th>
              @if(auth()->user()->is_teacher !== 1)
              <th>Enseignant</th>
              @endif
              <th width="50%">Fournitures</th>
              <th>Action</th>
            </tr>
            </thead>
            <tbody>

             @foreach($fournitures as $fourniture)
                <tr>

                  <td style="display: none;">{{ $fourniture->id }}</td>
                  
                                    
                  <td>{{ $fourniture->classe->name }}</td>

                  <td>{{ $fourniture->subject->name }}</td>


                  @if(auth()->user()->is_teacher !== 1)

                  <td>{{ $fourniture->teacher->last_name . ' ' . $fourniture->teacher->first_name }}</td>
                  
                  @endif


                  <td><?php echo html_entity_decode($fourniture->details); ?></td>



                  <td>


@if(auth()->user()->super_admin == 1)
                      
                        <a onclick="return confirm('Supprimer?')" href="{{ URL::route('admin_fournitures_annee_destroy', $fourniture->id) }}" class="btn btn-danger btn-sm mr-1 mb-2"><i class="fa fa-trash"></i> Supprimer</a>

                         <a href="#" data-toggle="modal" data-target="#mdf-{{ $fourniture->id }}" class="btn btn-success btn-sm mr-1 mb-2"><i class="fa fa-edit"></i> Modifier</a>


<!-- Modal -->
<div class="modal fade" id="mdf-{{ $fourniture->id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel{{ $fourniture->id }}" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel{{ $fourniture->id }}">Modifier</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">


<form method="POST" action="{{ URL::route('admin_fournitures_annee_update', $fourniture->id) }}" >

{{ csrf_field() }}

<div class="form-row">

  <div class="col-md-12 mb-3">
      <label>Matières / Classes</label>
      <select name="subject_id" class="selectpicker" data-width="100%" required="required">   
      <option value="">Choisir</option>
        @foreach($subjects as $subject)

        @if($subject->id == $fourniture->subject_id)
        <option value="{{ $subject->id }}" selected="selected">{{ $subject->name }} ({{ $getclass->name }})</option>
        @else
        <option value="{{ $subject->id }}">{{ $subject->name }} ({{ $subject->classe->name }})</option>
        @endif

          
        @endforeach
      </select>
  </div>


  <div class="col-md-12 mb-3">
    <label>Fournitures:</label>
    <textarea name="details" class="form-control" rows="8"><?php echo html_entity_decode($fourniture->details); ?></textarea>
  </div>


 
</div>

<div class="form-row mt-1">
<div class="col-md-12">
    <button class="btn btn-success btn-block" type="submit">Modifier</button>
</div>
</div>

</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->

@endif                


@if(auth()->user()->is_teacher == 1)
                      
                        <a onclick="return confirm('Supprimer?')" href="{{ URL::route('fournitures_annee_destroy', $fourniture->id) }}" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i>  </a>
@endif

                    </td>

                    </tr>






                    @endforeach
                  </tbody>
                  </table>
               </div>

    </div>
  </div>
</div>

                                     


</div><!-- END row -->
                
               

@stop