@extends('layouts.master_panel')

@section('title') الشعب @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

<link rel="stylesheet" href="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.css" />


@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" },
      "order": [[ 0, "desc" ]]
    });
  });
  </script>


<script type="text/javascript">

$(document).ready(function () { 

  $(document).on('click', '#addRow', function(){

      var html = '<div class="col-md-12 mb-1 DivSection"><div class="form-group"><label>الشعبة :</label><input name="orientations[]" type="text" class="form-control input-lg"></div></div>';

      $('#area').append(html);
        
  });



});

</script>

@stop


@section('content')


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">الشعب</h3>
                          
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
  <h5 class="card-header">
@if(auth()->user()->super_admin == 1)
  <a href="#" class="btn btn-primary mb-3" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-plus"></i> Ajouter </a>
@endif
  </h5>
  <div class="card-body">



<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel">Ajouter</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="POST" action="{{ URL::route('store_orientation_classes') }}">

{{ csrf_field() }}


<div class="form-row">

  <div class="col-md-12 mb-3">
      <label>Classes:</label>
      <select name="class_ids[]" class="selectpicker" data-width="100%" title="Choisir" multiple="multiple">  
        @foreach($classes as $classe)
          <option value="{{ $classe->id }}">{{ $classe->name }}</option>
        @endforeach
      </select>
  </div>

</div>

<div class="form-row">

<div class="col-md-10 mb-3">
<section id="area" class="row">
  <div class="col-md-12 mb-1 DivSection">
    <div class="form-group">
    <label>الشعبة :</label>
    <input name="orientations[]" type="text" class="form-control input-lg">
    </div>
  </div>
</section>
</div>

<div class="col-md-2 mb-3">
    <button id="addRow" type="button" class="btn btn-primary btn-block mt-4"><i class="fa fa-plus"></i></button>
</div>


</div>


<div class="form-row mt-1">
<div class="col-md-12">
    <button class="btn btn-success btn-block" type="submit">Ajouter</button>
</div>
</div>

</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->



@if(Session::has('error'))

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('error') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

@endif

@if(Session::has('success'))
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('success') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif

<div class="clearfix"></div>

      <div class="table-responsive">
          <table id="example" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th style="display: none;">#</th>
              <th>Classe</th>
              <th>الشعبة</th>
              <th>Action</th>
            </tr>
            </thead>
            <tbody>

@foreach($orientation as $orient)

              <tr>

                  <td style="display: none;">{{ $orient->id }}</td>

                                  
                  <td>{{ $orient->classe->name }} </td>
                  
                  <td>

<?php $pieces = explode(",", $orient->orientations); ?>    
@foreach($pieces as $piec)
@if($piec !== '') 
<span class="badge badge-info">{{ $piec }}</span> 
@endif
@endforeach         
                  </td>


                  <td>
                    @if(auth()->user()->super_admin == 1)
                    <a onclick="return confirm('Supprimer?')" href="{{ URL::route('delete_orientation_classes', $orient->id) }}" class="btn btn-danger btn-sm"><i class="fa fa-trash"></i>  </a>
                    @endif
                  </td>

              </tr>

@endforeach
                  </tbody>
                  </table>
               </div>

    </div>
  </div>
</div>

                                     


</div><!-- END row -->
                
               

@stop