@extends('layouts.master_panel')

@section('title') Modifier @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

<link rel="stylesheet" href="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.css" />


@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" },
      "order": [[ 0, "desc" ]]
    });
  });
  </script>


<script src="{{url('/')}}/assets/vendor/datepicker/moment.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/datepicker.js"></script>

<script src="{{url('/')}}/assets/vendor/datepicker/fr.js"></script>


<script type="text/javascript">
    $(function () {
        $('#datetimepickerdate').datetimepicker({
          format: 'DD/MM/YYYY',
          locale: 'fr'
      });
    });


    $('#datetimepicker4').datetimepicker({
        format: 'HH:mm',
        locale: 'fr'
    });

</script>



<script type="text/javascript">
$(document).ready(function () { 

        $('#teacherID').on('change',function(e){
          
          var teacher_id = e.target.value;

            $.ajax({
            type: "GET",
            url: "{{ url('/') }}/ajax_teacher_classes_subjects?teacher_id="+teacher_id,
                success: function(data) {  

                    var subcat =  $('#subjectID').empty();

                    $.each(data, function(key, val) { 
                    
                      subcat.append('<option value ="'+val.sbj_id+'">'+val.sbj_name+'  - '+val.cl_name+'</option>');
                    });

                    $('.selectpicker').selectpicker('refresh');


                }

            });


        });


});
</script>


@stop


@section('content')


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Grille d'évaluation de l'enseignant  </h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item active" aria-current="page">Modifier</li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 mb-1">

@if(Session::has('error'))

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('error') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

@endif

@if(Session::has('success'))
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('success') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif

</div>

<div class="clearfix"></div>


<form method="POST" action="{{ URL::route('admin_grille_evaluation_update', $grille_evaluation->id) }}" id="myForm" class="col-md-12">

{{ csrf_field() }}


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 mb-1">
  <div class="section-block">


<div class="card">
<div class="card-body">
<div class="row">

<div class="col-md-6 mb-3">
        <label>Enseignants:</label>
        <select name="teacher_id" id="teacherID" class="form-control" data-width="100%" required="required">
          <option value="{{ $grille_evaluation->teacher->id }}">{{ $grille_evaluation->teacher->last_name . ' ' . $grille_evaluation->teacher->first_name }}</option>
         </select>
</div>

<?php $FindSubject = \App\Subjects::find($grille_evaluation->subject_id); ?>
<div class="col-md-6 mb-3">
    <label>Matières - Classes:</label>
    <select name="subject_id" id="subjectID" class="selectpicker" data-width="100%" required="required">
      <option>@if($FindSubject !== null ) {{ $FindSubject->name }} - {{ $FindSubject->classe->name }} @endif</option>
    </select>
</div>

<?php 
$FrDateTime = \DateTime::createFromFormat('Y-m-d', $grille_evaluation->date);
?>

<div class="col-md-6 mb-3">
    <label>Date:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepickerdate" data-target-input="nearest">

    <input name="date" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdate" required="required" value="{{ $FrDateTime->format('d/m/Y') }}" />
    
      <div class="input-group-append" data-target="#datetimepickerdate" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
      </div>
    </div>
  </div>
</div>

<div class="col-md-6 mb-3">
    <label>Heure:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepicker4" data-target-input="nearest">

    <input name="heure" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker4" required="required" value="{{ $grille_evaluation->heure }}" />
    
      <div class="input-group-append" data-target="#datetimepicker4" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-clock"></i></div>
      </div>
    </div>
  </div>
</div>

<div class="col-md-12 mb-3">
    <div class="form-group">
    <label>Titre de la leçon observée:</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fas fa-pencil-alt"></i></span></div>
    <input name="titre" type="text" class="form-control" value="{{ $grille_evaluation->titre }}" required="required">
    </div>
    </div>
  </div>


</div>
</div>
</div><!-- END card -->
  </div>
  <div class="simple-card">
    <ul class="nav nav-tabs" id="myTab5" role="tablist" style="text-align: center;">
      
      <li class="nav-item">
        <a class="nav-link active border-left-0" id="home-tab-simple" data-toggle="tab" href="#home-simple" role="tab" aria-controls="home" aria-selected="true">Documentation de l'enseignant(e)</a>
      </li>

      <li class="nav-item">
        <a class="nav-link" id="exercices-tab-simple" data-toggle="tab" href="#exercices-simple" role="tab" aria-controls="exercices" aria-selected="false">Cahiers d'exercices</a>
      </li>

      <li class="nav-item">
        <a class="nav-link" id="lecons-tab-simple" data-toggle="tab" href="#lecons-simple" role="tab" aria-controls="lecons" aria-selected="false">Cahiers de leçons</a>
      </li>

      <li class="nav-item">
        <a class="nav-link" id="maison-tab-simple" data-toggle="tab" href="#maison-simple" role="tab" aria-controls="maison" aria-selected="false">Cahiers de maison/recherche</a>
      </li>

      <li class="nav-item">
        <a class="nav-link" id="Tcalsse-tab-simple" data-toggle="tab" href="#Tcalsse-simple" role="tab" aria-controls="Tcalsse" aria-selected="false">Le travail en classe</a>
      </li>

      <li class="nav-item">
        <a class="nav-link" id="Appreciation-tab-simple" data-toggle="tab" href="#Appreciation-simple" role="tab" aria-controls="Appreciation" aria-selected="false">Appréciation/Recommandations</a>
      </li>

    </ul>
    <div class="tab-content" id="myTabContent5">

      <div class="tab-pane fade show active" id="home-simple" role="tabpanel" aria-labelledby="home-tab-simple">

<div class="card" style="border: 1px solid #0328EB;">
<div class="card-header text-primary">Documentation de l'enseignant(e):</div>
<div class="card-body">
<div class="row">

<div class="col-md-6 mb-3">
  <label>Progression annuelle - respectée:</label>
  <select name="progression_annuelle_respectee" class="form-control" data-width="100%">
    @if($grille_evaluation->progression_annuelle_respectee == 1)
      <option value="1" selected="selected">Oui</option>
      <option value="0">Non</option>
    @else
      <option value="0" selected="selected">Non</option>
      <option value="1">Oui</option>
    @endif
  </select>
</div>


<div class="col-md-6 mb-3">
  <label>Progression annuelle - validée:</label>
  <select name="progression_annuelle_validee" class="form-control" data-width="100%">
    @if($grille_evaluation->progression_annuelle_validee == 1)
      <option value="1" selected="selected">Oui</option>
      <option value="0">Non</option>
    @else
      <option value="0" selected="selected">Non</option>
      <option value="1">Oui</option>
    @endif
  </select>
</div>

<div class="col-md-4 mb-3">
  <label>Progression semestrielle - respectée:</label>
  <select name="progression_semestrielle_respectee" class="form-control" data-width="100%">
    @if($grille_evaluation->progression_semestrielle_respectee == 1)
      <option value="1" selected="selected">Oui</option>
      <option value="0">Non</option>
    @else
      <option value="0" selected="selected">Non</option>
      <option value="1">Oui</option>
    @endif
  </select>
</div>


<div class="col-md-4 mb-3">
  <label>Progression semestrielle - validée:</label>
  <select name="progression_semestrielle_validee" class="form-control" data-width="100%">
    @if($grille_evaluation->progression_semestrielle_validee == 1)
      <option value="1" selected="selected">Oui</option>
      <option value="0">Non</option>
    @else
      <option value="0" selected="selected">Non</option>
      <option value="1">Oui</option>
    @endif
  </select>
</div>


<div class="col-md-4 mb-3">
  <label>L’emploi du temps - respecté:</label>
  <select name="emploi_temps_respecte" class="form-control" data-width="100%">
    @if($grille_evaluation->emploi_temps_respecte == 1)
      <option value="1" selected="selected">Oui</option>
      <option value="0">Non</option>
    @else
      <option value="0" selected="selected">Non</option>
      <option value="1">Oui</option>
    @endif
  </select>
</div>

<div class="col-md-4 mb-3">
  <label>Le cahier journal - à jour:</label>
  <select name="cahier_journal_ajour" class="form-control" data-width="100%">
    @if($grille_evaluation->cahier_journal_ajour == 1)
      <option value="1" selected="selected">Oui</option>
      <option value="0">Non</option>
    @else
      <option value="0" selected="selected">Non</option>
      <option value="1">Oui</option>
    @endif
  </select>
</div>

<div class="col-md-4 mb-3">
  <label>Le cahier journal - détaillé:</label>
  <select name="cahier_journal_detaille" class="form-control" data-width="100%">
    @if($grille_evaluation->cahier_journal_detaille == 1)
      <option value="1" selected="selected">Oui</option>
      <option value="0">Non</option>
    @else
      <option value="0" selected="selected">Non</option>
      <option value="1">Oui</option>
    @endif
  </select>
</div>

<div class="col-md-4 mb-3">
  <label>Le cahier journal - bien présenté:</label>
  <select name="cahier_journal_bpresente" class="form-control" data-width="100%">
    @if($grille_evaluation->cahier_journal_bpresente == 1)
      <option value="1" selected="selected">Oui</option>
      <option value="0">Non</option>
    @else
      <option value="0" selected="selected">Non</option>
      <option value="1">Oui</option>
    @endif
  </select>
</div>


<div class="col-md-4 mb-3">
  <label>Les fiches de préparation - sous format papier:</label>
  <select name="fiches_preparation_fpexiste" class="form-control" data-width="100%">
    @if($grille_evaluation->fiches_preparation_fpexiste == 1)
      <option value="1" selected="selected">Oui</option>
      <option value="0">Non</option>
    @else
      <option value="0" selected="selected">Non</option>
      <option value="1">Oui</option>
    @endif
  </select>
</div>

<div class="col-md-4 mb-3">
  <label>Les fiches de préparation - sous format numérique:</label>
  <select name="fiches_preparation_fnexiste" class="form-control" data-width="100%">
    @if($grille_evaluation->fiches_preparation_fnexiste == 1)
      <option value="1" selected="selected">Oui</option>
      <option value="0">Non</option>
    @else
      <option value="0" selected="selected">Non</option>
      <option value="1">Oui</option>
    @endif
  </select>
</div>

<div class="col-md-4 mb-3">
  <label>Les fiches de préparation - bien présentées:</label>
  <select name="fiches_preparation_bpresente" class="form-control" data-width="100%">
    @if($grille_evaluation->fiches_preparation_bpresente == 1)
      <option value="1" selected="selected">Oui</option>
      <option value="0">Non</option>
    @else
      <option value="0" selected="selected">Non</option>
      <option value="1">Oui</option>
    @endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>Les fiches de préparation - conforment au protocole N°1 d'enseignement:</label>
  <select name="fiches_preparation_conforment" class="form-control" data-width="100%">
    @if($grille_evaluation->fiches_preparation_conforment == 1)
      <option value="1" selected="selected">Oui</option>
      <option value="0">Non</option>
    @else
      <option value="0" selected="selected">Non</option>
      <option value="1">Oui</option>
    @endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>Les fiches de préparation - prévoit des exercices de soutien et d'approfondissement:</label>
  <select name="fiches_preparation_soutien_approfon" class="form-control" data-width="100%">
    @if($grille_evaluation->fiches_preparation_soutien_approfon == 1)
      <option value="1" selected="selected">Oui</option>
      <option value="0">Non</option>
    @else
      <option value="0" selected="selected">Non</option>
      <option value="1">Oui</option>
    @endif
  </select>
</div>


</div>
</div>
</div>

      </div><!-- END Documentation de l enseignant -->

      <div class="tab-pane fade" id="exercices-simple" role="tabpanel" aria-labelledby="exercices-tab-simple">

<div class="card" style="border: 1px solid #0328EB;">
<div class="card-header text-primary">Cahiers d'exercices:</div>
<div class="card-body">
<div class="row">

<div class="col-md-12 mb-3">
  <label>Fréquence des exercices réalisés par semaine:</label>
  <select name="cahiers_exercices_frequence" class="form-control" data-width="100%">
@if($grille_evaluation->cahiers_exercices_frequence == 1)
    <option value="1" selected="selected">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3">Pas assez</option>
@elseif($grille_evaluation->cahiers_exercices_frequence == 2)
  <option value="1">Toujours</option>
    <option value="2" selected="selected">Souvent</option>
    <option value="3">Pas assez</option>
@else
    <option value="1">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3" selected="selected">Pas assez</option>
@endif
  </select>
</div>


<div class="col-md-12 mb-3">
  <label>Qualité des exercices (appropriés):</label>
  <select name="cahiers_exercices_qualiteappropries" class="form-control" data-width="100%">
@if($grille_evaluation->cahiers_exercices_qualiteappropries == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-12 mb-3">
  <label>Qualité des exercices (diversifiés):</label>
  <select name="cahiers_exercices_qualitediversifies" class="form-control" data-width="100%">
@if($grille_evaluation->cahiers_exercices_qualitediversifies == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-12 mb-3">
  <label>Qualité des exercices (prévoient des tâches complexes):</label>
  <select name="cahiers_exercices_qualitetachescomplexe" class="form-control" data-width="100%">
@if($grille_evaluation->cahiers_exercices_qualitetachescomplexe == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>


<div class="col-md-6 mb-3">
  <label>Correction par les élèves:</label>
  <select name="cahiers_exercices_correction" class="form-control" data-width="100%">
@if($grille_evaluation->cahiers_exercices_correction == 1)
    <option value="1" selected="selected">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3">Pas assez</option>
@elseif($grille_evaluation->cahiers_exercices_correction == 2)
  <option value="1">Toujours</option>
    <option value="2" selected="selected">Souvent</option>
    <option value="3">Pas assez</option>
@else
    <option value="1">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3" selected="selected">Pas assez</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>Soins (propreté):</label>
  <select name="cahiers_exercices_soinsproprete" class="form-control" data-width="100%">
@if($grille_evaluation->cahiers_exercices_soinsproprete == 1)
    <option value="1" selected="selected">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3">Pas assez</option>
@elseif($grille_evaluation->cahiers_exercices_soinsproprete == 2)
  <option value="1">Toujours</option>
    <option value="2" selected="selected">Souvent</option>
    <option value="3">Pas assez</option>
@else
    <option value="1">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3" selected="selected">Pas assez</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>Soins (soulignement):</label>
  <select name="cahiers_exercices_soinssoulignement" class="form-control" data-width="100%">
@if($grille_evaluation->cahiers_exercices_soinssoulignement == 1)
    <option value="1" selected="selected">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3">Pas assez</option>
@elseif($grille_evaluation->cahiers_exercices_soinssoulignement == 2)
  <option value="1">Toujours</option>
    <option value="2" selected="selected">Souvent</option>
    <option value="3">Pas assez</option>
@else
    <option value="1">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3" selected="selected">Pas assez</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>Notation des exercices:</label>
  <select name="cahiers_exercices_notation" class="form-control" data-width="100%">
@if($grille_evaluation->cahiers_exercices_notation == 1)
    <option value="1" selected="selected">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3">Pas assez</option>
@elseif($grille_evaluation->cahiers_exercices_notation == 2)
  <option value="1">Toujours</option>
    <option value="2" selected="selected">Souvent</option>
    <option value="3">Pas assez</option>
@else
    <option value="1">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3" selected="selected">Pas assez</option>
@endif
  </select>
</div>

<div class="col-md-12 mb-3">
  <label>Appréciations existantes:</label>
  <select name="cahiers_exercices_appreciationsexist" class="form-control" data-width="100%">
@if($grille_evaluation->cahiers_exercices_appreciationsexist == 1)
    <option value="1" selected="selected">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3">Pas assez</option>
@elseif($grille_evaluation->cahiers_exercices_appreciationsexist == 2)
  <option value="1">Toujours</option>
    <option value="2" selected="selected">Souvent</option>
    <option value="3">Pas assez</option>
@else
    <option value="1">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3" selected="selected">Pas assez</option>
@endif
  </select>
</div>

<div class="col-md-12 mb-3">
  <label>Favorisant davantage l’implication de l’élève:</label>
  <select name="cahiers_exercices_appreciationsimplication" class="form-control" data-width="100%">
@if($grille_evaluation->cahiers_exercices_appreciationsimplication == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>



</div>
</div>
</div>

      </div><!-- END Cahiers dexercices -->

      <div class="tab-pane fade" id="lecons-simple" role="tabpanel" aria-labelledby="lecons-tab-simple">

<div class="card" style="border: 1px solid #0328EB;">
<div class="card-header text-primary">Cahiers de leçons:</div>
<div class="card-body">
<div class="row">


<div class="col-md-6 mb-3">
  <label>Soins (propreté):</label>
  <select name="cahiers_lecons_soinsproprete" class="form-control" data-width="100%">
@if($grille_evaluation->cahiers_lecons_soinsproprete == 1)
    <option value="1" selected="selected">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3">Pas assez</option>
@elseif($grille_evaluation->cahiers_lecons_soinsproprete == 2)
  <option value="1">Toujours</option>
    <option value="2" selected="selected">Souvent</option>
    <option value="3">Pas assez</option>
@else
    <option value="1">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3" selected="selected">Pas assez</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>Soins (soulignement):</label>
  <select name="cahiers_lecons_soinssoulignement" class="form-control" data-width="100%">
@if($grille_evaluation->cahiers_lecons_soinssoulignement == 1)
    <option value="1" selected="selected">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3">Pas assez</option>
@elseif($grille_evaluation->cahiers_lecons_soinssoulignement == 2)
  <option value="1">Toujours</option>
    <option value="2" selected="selected">Souvent</option>
    <option value="3">Pas assez</option>
@else
    <option value="1">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3" selected="selected">Pas assez</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>Visés par l’enseignant:</label>
  <select name="cahiers_lecons_visesenseignant" class="form-control" data-width="100%">
@if($grille_evaluation->cahiers_lecons_visesenseignant == 1)
    <option value="1" selected="selected">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3">Pas assez</option>
@elseif($grille_evaluation->cahiers_lecons_visesenseignant == 2)
  <option value="1">Toujours</option>
    <option value="2" selected="selected">Souvent</option>
    <option value="3">Pas assez</option>
@else
    <option value="1">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3" selected="selected">Pas assez</option>
@endif
  </select>
</div>


<div class="col-md-6 mb-3">
  <label>À jour:</label>
  <select name="cahiers_lecons_ajour" class="form-control" data-width="100%">
@if($grille_evaluation->cahiers_lecons_ajour == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>Visés:</label>
  <select name="cahiers_lecons_vises" class="form-control" data-width="100%">
@if($grille_evaluation->cahiers_lecons_vises == 1)
    <option value="1" selected="selected">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3">Pas assez</option>
@elseif($grille_evaluation->cahiers_lecons_vises == 2)
  <option value="1">Toujours</option>
    <option value="2" selected="selected">Souvent</option>
    <option value="3">Pas assez</option>
@else
    <option value="1">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3" selected="selected">Pas assez</option>
@endif
  </select>
</div>


</div>
</div>
</div>

      </div><!-- END Cahiers de leçons -->

      <div class="tab-pane fade" id="maison-simple" role="tabpanel" aria-labelledby="maison-tab-simple">

<div class="card" style="border: 1px solid #0328EB;">
<div class="card-header text-primary">Cahiers de maison/recherche:</div>
<div class="card-body">
<div class="row">


<div class="col-md-12 mb-3">
  <label>Fréquence des exercices réalisés par semaine:</label>
  <select name="cahiers_maison_frequence" class="form-control" data-width="100%">
@if($grille_evaluation->cahiers_maison_frequence == 1)
    <option value="1" selected="selected">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3">Pas assez</option>
@elseif($grille_evaluation->cahiers_maison_frequence == 2)
  <option value="1">Toujours</option>
    <option value="2" selected="selected">Souvent</option>
    <option value="3">Pas assez</option>
@else
    <option value="1">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3" selected="selected">Pas assez</option>
@endif
  </select>
</div>

<div class="col-md-12 mb-3">
  <label>Qualité des exercices (appropriés):</label>
  <select name="cahiers_maison_qualiteappropries" class="form-control" data-width="100%">
@if($grille_evaluation->cahiers_maison_qualiteappropries == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-12 mb-3">
  <label>Qualité des exercices (diversifiés):</label>
  <select name="cahiers_maison_qualitediversifies" class="form-control" data-width="100%">
@if($grille_evaluation->cahiers_maison_qualitediversifies == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-12 mb-3">
  <label>Qualité des exercices (Tâches complexes):</label>
  <select name="cahiers_maison_qualitetachescomplexe" class="form-control" data-width="100%">
@if($grille_evaluation->cahiers_maison_qualitetachescomplexe == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>


<div class="col-md-6 mb-3">
  <label>Correction par les élèves:</label>
  <select name="cahiers_maison_correction" class="form-control" data-width="100%">
@if($grille_evaluation->cahiers_maison_correction == 1)
    <option value="1" selected="selected">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3">Pas assez</option>
@elseif($grille_evaluation->cahiers_maison_correction == 2)
  <option value="1">Toujours</option>
    <option value="2" selected="selected">Souvent</option>
    <option value="3">Pas assez</option>
@else
    <option value="1">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3" selected="selected">Pas assez</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>Soins (propreté):</label>
  <select name="cahiers_maison_soinsproprete" class="form-control" data-width="100%">
@if($grille_evaluation->cahiers_maison_soinsproprete == 1)
    <option value="1" selected="selected">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3">Pas assez</option>
@elseif($grille_evaluation->cahiers_maison_soinsproprete == 2)
  <option value="1">Toujours</option>
    <option value="2" selected="selected">Souvent</option>
    <option value="3">Pas assez</option>
@else
    <option value="1">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3" selected="selected">Pas assez</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>Soins (soulignement):</label>
  <select name="cahiers_maison_soinssoulignement" class="form-control" data-width="100%">
@if($grille_evaluation->cahiers_maison_soinssoulignement == 1)
    <option value="1" selected="selected">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3">Pas assez</option>
@elseif($grille_evaluation->cahiers_maison_soinssoulignement == 2)
  <option value="1">Toujours</option>
    <option value="2" selected="selected">Souvent</option>
    <option value="3">Pas assez</option>
@else
    <option value="1">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3" selected="selected">Pas assez</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>Notation des exercices:</label>
  <select name="cahiers_maison_notation" class="form-control" data-width="100%">
@if($grille_evaluation->cahiers_maison_notation == 1)
    <option value="1" selected="selected">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3">Pas assez</option>
@elseif($grille_evaluation->cahiers_maison_notation == 2)
  <option value="1">Toujours</option>
    <option value="2" selected="selected">Souvent</option>
    <option value="3">Pas assez</option>
@else
    <option value="1">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3" selected="selected">Pas assez</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>Appréciations existantes:</label>
  <select name="cahiers_maison_appreciationsexist" class="form-control" data-width="100%">
@if($grille_evaluation->cahiers_maison_appreciationsexist == 1)
    <option value="1" selected="selected">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3">Pas assez</option>
@elseif($grille_evaluation->cahiers_maison_appreciationsexist == 2)
  <option value="1">Toujours</option>
    <option value="2" selected="selected">Souvent</option>
    <option value="3">Pas assez</option>
@else
    <option value="1">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3" selected="selected">Pas assez</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>Visés:</label>
  <select name="cahiers_maison_vises" class="form-control" data-width="100%">
@if($grille_evaluation->cahiers_maison_vises == 1)
    <option value="1" selected="selected">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3">Pas assez</option>
@elseif($grille_evaluation->cahiers_maison_vises == 2)
  <option value="1">Toujours</option>
    <option value="2" selected="selected">Souvent</option>
    <option value="3">Pas assez</option>
@else
    <option value="1">Toujours</option>
    <option value="2">Souvent</option>
    <option value="3" selected="selected">Pas assez</option>
@endif
  </select>
</div>

</div>
</div>
</div>

      </div><!-- END Cahiers de maison -->

      <div class="tab-pane fade" id="Tcalsse-simple" role="tabpanel" aria-labelledby="Tcalsse-tab-simple">
<div class="card" style="border: 1px solid #0328EB;">
<div class="card-header text-primary">LE TRAVAIL EN CLASSE - Intérêt de l'enseignant pour son cours:</div>
<div class="card-body">
<div class="row">


<div class="col-md-6 mb-3">
  <label>utilise différents supports pédagogiques:</label>
  <select name="interet_supportspedagogiques" class="form-control" data-width="100%">
@if($grille_evaluation->interet_supportspedagogiques == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>lit ses notes ou un document écrit:</label>
  <select name="interet_lirenotes" class="form-control" data-width="100%">
@if($grille_evaluation->interet_lirenotes == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>suggère des implications pratiques:</label>
  <select name="interet_implicationspratiques" class="form-control" data-width="100%">
@if($grille_evaluation->interet_implicationspratiques == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>montre de l'intérêt et de l'enthousiasme:</label>
  <select name="interet_montreenthousiasme" class="form-control" data-width="100%">
@if($grille_evaluation->interet_montreenthousiasme == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>


</div>
</div>
</div><!-- END card -->


<div class="card" style="border: 1px solid #0328EB;">
<div class="card-header text-primary">LE TRAVAIL EN CLASSE - Clarté du cours:</div>
<div class="card-body">
<div class="row">


<div class="col-md-6 mb-3">
  <label>utilise un débit de parole approprié:</label>
  <select name="clartecours_paroleapproprie" class="form-control" data-width="100%">
@if($grille_evaluation->clartecours_paroleapproprie == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>parle d'une voix non monotone:</label>
  <select name="clartecours_nonmonotone" class="form-control" data-width="100%">
@if($grille_evaluation->clartecours_nonmonotone == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>s'exprime clairement:</label>
  <select name="clartecours_exprimeclairement" class="form-control" data-width="100%">
@if($grille_evaluation->clartecours_exprimeclairement == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>avance dans son cours à une vitesse mesurée:</label>
  <select name="clartecours_avancecoursvmesuree" class="form-control" data-width="100%">
@if($grille_evaluation->clartecours_avancecoursvmesuree == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-12 mb-3">
  <label>utilise le tableau pour rendre son cours plus clair:</label>
  <select name="clartecours_utilisetableau" class="form-control" data-width="100%">
@if($grille_evaluation->clartecours_utilisetableau == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>


</div>
</div>
</div><!-- END card -->



<div class="card" style="border: 1px solid #0328EB;">
<div class="card-header text-primary">LE TRAVAIL EN CLASSE - Relation avec les élèves:</div>
<div class="card-body">
<div class="row">


<div class="col-md-6 mb-3">
  <label>accepte des points de vue divergents:</label>
  <select name="relationeleves_pointsvuedivergents" class="form-control" data-width="100%">
@if($grille_evaluation->relationeleves_pointsvuedivergents == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>apporte de l'aide en cas d'incompréhension:</label>
  <select name="relationeleves_apporteaide" class="form-control" data-width="100%">
@if($grille_evaluation->relationeleves_apporteaide == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>montre du respect envers les élèves:</label>
  <select name="relationeleves_montrerespect" class="form-control" data-width="100%">
@if($grille_evaluation->relationeleves_montrerespect == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>


</div>
</div>
</div><!-- END card -->



<div class="card" style="border: 1px solid #0328EB;">
<div class="card-header text-primary">LE TRAVAIL EN CLASSE - Organisation du cours:</div>
<div class="card-body">
<div class="row">


<div class="col-md-6 mb-3">
  <label>donne les objectifs de son cours:</label>
  <select name="organisationcours_donneobjectifs" class="form-control" data-width="100%">
@if($grille_evaluation->organisationcours_donneobjectifs == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>présente le cours de manière organisée:</label>
  <select name="organisationcours_organise" class="form-control" data-width="100%">
@if($grille_evaluation->organisationcours_organise == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>donne des documents de travail:</label>
  <select name="organisationcours_donnedocuments" class="form-control" data-width="100%">
@if($grille_evaluation->organisationcours_donnedocuments == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>fait des synthèses utiles lors de son cours:</label>
  <select name="organisationcours_faitsyntheses" class="form-control" data-width="100%">
@if($grille_evaluation->organisationcours_faitsyntheses == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>respecte les 3 temps de la séance:</label>
  <select name="organisationcours_respecte3temps" class="form-control" data-width="100%">
@if($grille_evaluation->organisationcours_respecte3temps == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>


</div>
</div>
</div><!-- END card -->





<div class="card" style="border: 1px solid #0328EB;">
<div class="card-header text-primary">LE TRAVAIL EN CLASSE - Incitation à la participation:</div>
<div class="card-body">
<div class="row">


<div class="col-md-6 mb-3">
  <label>encourage les questions et les commentaires:</label>
  <select name="incitationparticipation_encouragequestions" class="form-control" data-width="100%">
@if($grille_evaluation->incitationparticipation_encouragequestions == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>questionne individuellement les élèves:</label>
  <select name="incitationparticipation_questionneindividuellement" class="form-control" data-width="100%">
@if($grille_evaluation->incitationparticipation_questionneindividuellement == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>pose des questions à la classe entière:</label>
  <select name="incitationparticipation_posequestions" class="form-control" data-width="100%">
@if($grille_evaluation->incitationparticipation_posequestions == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>incite les élèves à interagir:</label>
  <select name="incitationparticipation_inciteeleves" class="form-control" data-width="100%">
@if($grille_evaluation->incitationparticipation_inciteeleves == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>pose des questions complexes:</label>
  <select name="incitationparticipation_questionscomplexes" class="form-control" data-width="100%">
@if($grille_evaluation->incitationparticipation_questionscomplexes == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>


</div>
</div>
</div><!-- END card -->







<div class="card" style="border: 1px solid #0328EB;">
<div class="card-header text-primary">LE TRAVAIL EN CLASSE - Explications:</div>
<div class="card-body">
<div class="row">


<div class="col-md-6 mb-3">
  <label>utilise des exemples:</label>
  <select name="explications_utiliseexemples" class="form-control" data-width="100%">
@if($grille_evaluation->explications_utiliseexemples == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>répète ce qui est difficile:</label>
  <select name="explications_repetedifficile" class="form-control" data-width="100%">
@if($grille_evaluation->explications_repetedifficile == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-4 mb-3">
  <label>souligne les points centraux:</label>
  <select name="explications_pointscentraux" class="form-control" data-width="100%">
@if($grille_evaluation->explications_pointscentraux == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif>
  </select>
</div>

<div class="col-md-4 mb-3">
  <label>donne des détails utiles:</label>
  <select name="explications_donnedetails" class="form-control" data-width="100%">
@if($grille_evaluation->explications_donnedetails == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-4 mb-3">
  <label>identifie les points clés:</label>
  <select name="explications_pointscles" class="form-control" data-width="100%">
@if($grille_evaluation->explications_pointscles == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>


</div>
</div>
</div><!-- END card -->






<div class="card" style="border: 1px solid #0328EB;">
<div class="card-header text-primary">LE TRAVAIL EN CLASSE - Attitude des élèves:</div>
<div class="card-body">
<div class="row">


<div class="col-md-6 mb-3">
  <label>sont attentifs et appliqués:</label>
  <select name="attitudeeleves_attentifs" class="form-control" data-width="100%">
@if($grille_evaluation->attitudeeleves_attentifs == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>participent activement au cours:</label>
  <select name="attitudeeleves_participentactivement" class="form-control" data-width="100%">
@if($grille_evaluation->attitudeeleves_participentactivement == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>respectent l'enseignant(e):</label>
  <select name="attitudeeleves_respectent" class="form-control" data-width="100%">
@if($grille_evaluation->attitudeeleves_respectent == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>sont motivés par le cours:</label>
  <select name="attitudeeleves_motives" class="form-control" data-width="100%">
@if($grille_evaluation->attitudeeleves_motives == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>


</div>
</div>
</div><!-- END card -->





<div class="card" style="border: 1px solid #0328EB;">
<div class="card-header text-primary">LE TRAVAIL EN CLASSE:</div>
<div class="card-body">
<div class="row">


<div class="col-md-6 mb-3">
  <label>Matériel didactique - existant:</label>
  <select name="materieldidactique_existant" class="form-control" data-width="100%">
@if($grille_evaluation->materieldidactique_existant == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>Matériel didactique - bien utilisé:</label>
  <select name="materieldidactique_bienutilise" class="form-control" data-width="100%">
@if($grille_evaluation->materieldidactique_bienutilise == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>Respecte l’emploi du temps:</label>
  <select name="tc_respecteemploi" class="form-control" data-width="100%">
@if($grille_evaluation->tc_respecteemploi == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>

<div class="col-md-6 mb-3">
  <label>Respecte le temps attribué à la discipline:</label>
  <select name="tc_respectetempsattribue" class="form-control" data-width="100%">
@if($grille_evaluation->tc_respectetempsattribue == 1)
    <option value="1" selected="selected">Oui</option>
    <option value="0">Non</option>
@else
    <option value="0" selected="selected">Non</option>
    <option value="1">Oui</option>
@endif
  </select>
</div>


</div>
</div>
</div><!-- END card -->




      </div><!-- END Travail en classe -->

      <div class="tab-pane fade" id="Appreciation-simple" role="tabpanel" aria-labelledby="Appreciation-tab-simple">

<div class="card" style="border: 1px solid #0328EB;">
<div class="card-body">
<div class="row">


<div class="col-md-12 mb-3">
    <label>Appréciation générale:</label>
    <textarea name="appreciation_general" class="form-control" required="required" rows="5"><?php echo strip_tags(html_entity_decode($grille_evaluation->appreciation_general)); ?></textarea>
</div>

<div class="col-md-12 mb-3">
    <label>Recommandations:</label>
    <textarea name="recommandations" class="form-control" required="required" rows="5"><?php echo strip_tags(html_entity_decode($grille_evaluation->recommandations)); ?></textarea>
</div>


</div>
</div>
</div>

      </div><!-- END Appréciation -->

    </div>
  </div>
</div>
 





<div class="col-md-12 mb-3 mt-3">
    <button class="btn btn-success btn-lg btn-block" type="submit">Modifier</button>
</div>




</form>


                                     



</div><!-- END row -->
                
               

@stop