<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class AbsencesStudents extends Model
{
    protected $table = 'absences_students';

    protected $guarded = ['id', 'created_at'];


    public function classe()
	{
		return $this->belongsTo('App\Classes', 'class_id');
	}

	public function subject()
	{
		return $this->belongsTo('App\Subjects', 'subject_id');
	}

	public function student()
	{
		return $this->belongsTo('App\User', 'student_id');
	}

	public function teacher()
	{
		return $this->belongsTo('App\User', 'teacher_id');
	}

	public function perso()
	{
		return $this->belongsTo('App\User', 'agent_id');
	}

}
