

<?php $__env->startSection('title'); ?> <?php echo e(html_entity_decode($folder->folder_name)); ?> <?php $__env->stopSection(); ?>

<?php $__env->startSection('CSS'); ?> 



<link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/js/datatables/dataTables.bootstrap4.min.css">

<style type="text/css">
.figure-attachment {
    min-height: 100px;
}
.fa-lg {
  font-size: 36px !important;
}


</style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('JS'); ?> 


<script src="<?php echo e(url('/')); ?>/js/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo e(url('/')); ?>/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "<?php echo e(url('/')); ?>/js/datatables/lang/fr.json" }
    });
  });
  </script>



<script type="text/javascript">
$(document).ready(function(){

    $("#FormID").submit(function(evn){

        evn.preventDefault();

                    $('.resp-div').css('display', 'block');
                    $('.myprogress').css('width', '0%');
                    $('.msg').text('');

                    var file_name = $('#file_name').val();
                    var myfile = $('#myfile').val();
                  //  var token = $('#token').val();

                    var formData = new FormData();

                  //  formData.append('_token', token);

                    formData.append('file', $('#file')[0].files[0]);
                    formData.append('file_name', file_name);
                    

                    $('#submit').css('display', 'none');
                    $('.msg').text('Téléchargement en cours ...');

                    $.ajax({
                        url: '<?php echo e(URL::route("files_store", $folder->id)); ?>',
                        data: formData,
                        processData: false,
                        contentType: false,
                        type: 'POST',
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        // this part is progress bar
                        xhr: function () {
                            var xhr = new window.XMLHttpRequest();
                            xhr.upload.addEventListener("progress", function (evt) {
                                if (evt.lengthComputable) {
                                    var percentComplete = evt.loaded / evt.total;
                                    percentComplete = parseInt(percentComplete * 99);
                                    $('.myprogress').text(percentComplete + '%');
                                    $('.myprogress').css('width', percentComplete + '%');
                                }
                            }, false);
                            return xhr;
                        },
                        success: function (data) {
                            $('.msg').html(data);
                            $('.myprogress').text('100%');
                            $('.myprogress').css('width', '100%');
                            $('#submit').css('display', 'block');
                            $('#FormID input').val('');
                        }
                    });
    });
});

function refresh() {
  window.location='<?php echo e(URL::current()); ?>';
}

function ValidateSize(file) {
  var FileSize = file.files[0].size / 1024 / 1024; // in MB
  if (FileSize > 50) {
      $('#file').val(''); //for clearing with Jquery
      alert('La taille du fichier dépasse 50 Mo');
      
  } 
}

</script>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
                  
                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2"><?php echo e(html_entity_decode($folder->folder_name)); ?></h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">

                                        <?php if(auth()->user()->is_admin == 1): ?>  

                                          <li class="breadcrumb-item"><a href="<?php echo e(URL::route('admin_index')); ?>" class="breadcrumb-link">Accueil</a></li>

                                          <li class="breadcrumb-item"><a href="<?php echo e(URL::route('enseignant_dossiers')); ?>" class="breadcrumb-link">Dossiers</a></li>

                                        <?php else: ?>

                                          <li class="breadcrumb-item"><a href="<?php echo e(URL::route('enseignant_index')); ?>" class="breadcrumb-link">Accueil</a></li>

                                          <li class="breadcrumb-item"><a href="<?php echo e(URL::route('enseignant_documents')); ?>" class="breadcrumb-link">Mes dossiers</a></li>

                                        <?php endif; ?>


                                          <li class="breadcrumb-item active" aria-current="page"><?php echo e(html_entity_decode($folder->folder_name)); ?></li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
    <h5 class="card-header">

<?php if(auth()->user()->super_admin == 1 OR auth()->user()->is_teacher == 1): ?>

      <a href="#" class="btn btn-primary mb-1" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-plus"></i> Déposer des ressources </a>

<?php endif; ?>

    </h5>
  <div class="card-body">

<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel">Déposer des ressources</h5>
      <a  onclick="refresh();" href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<div class="col-md-12 text-center resp-div" style="display: none;">
  <div class="msg mb-3"></div>

    <div class="progress mb-3" style="margin: auto;">
      <div class="progress-bar progress-bar-success progress-bar-striped myprogress" role="progressbar" style="width:0%; ">0%</div>
    </div>
    
</div>



<div class="clearfix"></div>


<form method="POST" id="FormID" action="#" enctype="multipart/form-data">

<input type="hidden" name="_token" id="token" value="<?php echo e(csrf_token()); ?>">


  <div class="col-md-12">
    <div class="form-group">
    <label>Nom de fichier:</label>
    <input name="file_name" type="text" class="form-control input-lg" value="<?php echo e(old('file_name')); ?>" id="file_name" required="required">
    </div>
  </div>

<div class="col-md-12">
      <label>fichier</label>
        <div class="custom-file">
          <input type="file" name="file" id="file" required="required" onchange="ValidateSize(this)">
        </div>
        <small class="form-text">Fichiers autorisés: <span class="text-uppercase">jpg|jpeg|gif|png|bmp|pdf|doc|docx|txt|ppt|pptx|xls|xlsx|zip|rar|mp4|avi|mpeg|mpg|mov|wmv|rm|3gp|webm</span></small>
        <small class="form-text text-danger">La taille limite du fichier est de 50Mo </small>
        
        <?php if($errors->first('file')): ?>
          <small class="form-text text-danger"><?php echo e($errors->first('file')); ?></small>
        <?php endif; ?>
</div>

<div class="clearfix"></div><br>

<div class="col-md-12">
    <button type="submit" name="submit" id="submit" class="btn btn-success btn-block input-lg">Déposer</button>
</div>

<div class="clearfix"></div>


</form>



    </div>
    <div class="modal-footer">
      <a  onclick="refresh();" href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->




<div class="clearfix"></div>

<?php if(Session::has('error')): ?>

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong><?php echo e(Session::get('error')); ?></strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

<?php endif; ?>

<?php if(Session::has('success')): ?>
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong><?php echo e(Session::get('success')); ?></strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
<?php endif; ?>

<div class="clearfix"></div>


<?php 
function formatSizeUnits($bytes)
    {
        if ($bytes >= 1073741824)
        {
            $bytes = number_format($bytes / 1073741824, 2) . ' GB';
        }
        elseif ($bytes >= 1048576)
        {
            $bytes = number_format($bytes / 1048576, 2) . ' MB';
        }
        elseif ($bytes >= 1024)
        {
            $bytes = number_format($bytes / 1024, 2) . ' KB';
        }
        elseif ($bytes > 1)
        {
            $bytes = $bytes . ' bytes';
        }
        elseif ($bytes == 1)
        {
            $bytes = $bytes . ' byte';
        }
        else
        {
            $bytes = '0 bytes';
        }

        return $bytes;
}


 ?>

        <div class="table-responsive">
          <table id="example" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th style="width: 20%">Nom de fichier</th>
              <th>Télécharger</th>
              <th>Type de fichier</th>
              <th>Taille du fichier</th>
              <th>Date</th>
              <th>Action</th>
            </tr>
            </thead>
            <tbody>

             <?php $__currentLoopData = $files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fil): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                                                
                    <td><?php echo e(html_entity_decode($fil->file_name)); ?></td>

                    <td class="text-center">
                      <a class="btn btn-rounded btn-dark btn-sm" target="_black" href="<?php echo e(url('/')); ?>/uploads/files/<?php echo e($fil->file_path); ?>"><i class="fas fa-download"></i></a>
                      
                    </td>

                    <td class="text-uppercase"><?php echo e($fil->file_type); ?></td>
                    <td><?php echo e(formatSizeUnits($fil->file_size)); ?></td>
                    
                    <td>
                    <?php $enTofr = DateTime::createFromFormat('Y-m-d H:i', substr($fil->created_at, 0, 16)); ?>

                      <?php echo e($enTofr->format('d/m/Y H:i')); ?>

                    </td>

                    <td>

                      <?php if(auth()->user()->super_admin == 1 OR auth()->user()->is_teacher == 1): ?>

                        <a href="#" data-toggle="modal" data-target="#exampleModal-<?php echo e($fil->id); ?>" class="btn btn-success btn-sm"><i class="fa fa-edit"></i> Renommer</a>
                      <?php endif; ?>


                        <?php if(auth()->user()->super_admin == 1): ?>

                          <a onclick="return confirm('Supprimer?')" href="<?php echo e(URL::route('file_delete', $fil->id)); ?>" class="btn btn-danger btn-sm"><i class="fa fa-edit"></i> Supprimer</a>

                        <?php endif; ?>

<!-- Modal -->
<div class="modal fade" id="exampleModal-<?php echo e($fil->id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-<?php echo e($fil->id); ?>" aria-hidden="true">
<div class="modal-dialog" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel-<?php echo e($fil->id); ?>">Renommer</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="POST" action="<?php echo e(URL::route('files_update', [$folder->id, $fil->id])); ?>">

<?php echo e(csrf_field()); ?>



  <div class="col-md-12">
    <div class="form-group">
    <label>Nom de fichier:</label>
    <input name="file_name_up" type="text" class="form-control input-lg" value="<?php echo e($fil->file_name); ?>" required>
    </div>
  </div>


<div class="clearfix"></div><br>

<div class="col-md-12">
    <button class="btn btn-success btn-block input-lg" type="submit">Renommer</button>
</div>


</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->

                    </td>

                  </tr>



                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </tbody>
              </table>
          </div>



    </div>
  </div>
</div>

                          
</div><!-- END row -->

                    

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master_panel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/verdin/pedagogie.verdin.ma/resources/views/enseignants/folder_files.blade.php ENDPATH**/ ?>